# Anonymized DNS relays

Anonymized DNS is a lightweight alternative to Tor and SOCKS proxies,
dedicated to DNS traffic. They hide the client IP address to DNS resolvers,
providing anonymity in addition to confidentiality and integrity.

DNS Anonymization is only compatible with servers supporting the
DNSCrypt protocol.

See the link below for more information:

https://github.com/DNSCrypt/dnscrypt-proxy/wiki/Anonymized-DNS


## anon-cs-austria

Wien, Austria Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ05NC4xOTguNDEuMjM1


## anon-cs-barcelona

Barcelona, Spain Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMTQyLjExNQ


## anon-cs-belgium

Brussels, Belgium Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0zNy4xMjAuMjM2LjEx


## anon-cs-berlin

Berlin, Germany Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0zNy4xMjAuMjE3Ljc1


## anon-cs-brazil

Brazil Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xNzcuNTQuMTQ1LjEzMQ


## anon-cs-bulgaria

Sofia, Bulgaria Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMTUyLjIzNQ


## anon-cs-ch

Switzerland Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ8xOTAuMjExLjI1NS4yMjc


## anon-cs-czech

Prague, Czech Republic Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ8yMTcuMTM4LjIyMC4yNDM


## anon-cs-dc

US - Washington, DC Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQwxOTguNy41OC4yMjc


## anon-cs-de

Frankfurt, Germany Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQsxNDYuNzAuODIuMw


## anon-cs-dk

Denmark Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0zNy4xMjAuMjMyLjQz


## anon-cs-dus3

Dusseldorf, Germany 3 Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ44OS4xNjMuMjIxLjE4MQ


## anon-cs-finland

Finland Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xODUuMTE3LjExOC4yMA


## anon-cs-fr

France Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xNjMuMTcyLjM0LjU2


## anon-cs-ga

US - Atlanta, GA Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ02NC40Mi4xODEuMjI3


## anon-cs-hungary

Budapest, Hungary Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ04Ni4xMDYuNzQuMjE5


## anon-cs-il2

US - Chicago, IL 2 Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xMDguMTgxLjYzLjE2Mw


## anon-cs-ireland

Dublin, Ireland Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMjM1LjE4Nw


## anon-cs-la

US - Los Angeles, CA Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ8xOTUuMjA2LjEwNC4yMDM


## anon-cs-london

London, England Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ03OC4xMjkuMjQ4LjY3


## anon-cs-madrid

Madrid, Spain Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xODUuMTgzLjEwNi44Mw


## anon-cs-manchester

Manchester, England Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xOTUuMTIuNDguMTcx


## anon-cs-mexico

Mexico Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xMDMuMTQuMjYuMTkw


## anon-cs-milan

Milan, Italy Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ8yMTcuMTM4LjIxOS4yMTk


## anon-cs-montreal

Montreal, Canada Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xNzYuMTEzLjc0LjE5


## anon-cs-nc

US - North Carolina Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xNTUuMjU0LjIxLjI1MA


## anon-cs-nl

Netherlands Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xODUuMTA3LjgwLjg0


## anon-cs-norway

Oslo, Norway Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ45MS4yMTkuMjE1LjIyNw


## anon-cs-ore

US - Oregon Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xNzkuNjEuMjIzLjQ3


## anon-cs-poland

Warsaw, Poland Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0zNy4xMjAuMjExLjkx


## anon-cs-pt

Portugal Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ45MS4yMDUuMjMwLjIyNA


## anon-cs-ro

Romania Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0xNDYuNzAuNjYuMjI3


## anon-cs-rome

Rome, Italy Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMjA3LjEzMQ


## anon-cs-sea

US - Seattle, WA Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQw2NC4xMjAuNS4yNTE


## anon-cs-serbia

Belgrade, Serbia Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMTkzLjIxOQ


## anon-cs-singapore

Singapore Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0zNy4xMjAuMTUxLjEx


## anon-cs-sk

South Korea Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xMDguMTgxLjUwLjIxOA


## anon-cs-slovakia

Bratislava, Slovakia Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xOTMuMzcuMjU1LjIyNw


## anon-cs-swe

Sweden Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ8xMjguMTI3LjEwNC4xMDg


## anon-cs-sydney

Sydney, Australia Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4zNy4xMjAuMjM0LjI1MQ


## anon-cs-tokyo

Tokyo, Japan Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQwxNDYuNzAuMzEuNDM


## anon-cs-tx

US - Dallas, TX Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ0yMDkuNTguMTQ3LjM2


## anon-cs-vancouver

Vancouver, Canada Anonymized DNS relay server provided by https://cryptostorm.is/

sdns://gQ4xOTYuMjQwLjc5LjE2Mw


## anon-digitalprivacy.diy-ipv4

IPv4 server. Anonymized DNS relay hosted in Nuremberg, Germany (netcup) and maintained by https://digitalprivacy.diy

sdns://gRIzNy4yMjEuMTk0Ljg0OjQ0MzQ


## anon-dnscrypt.uk-ipv4

Anonymized DNS relay in London. https://www.dnscrypt.uk

sdns://gQ0xNjUuMjMyLjMyLjk1


## anon-dnscrypt.uk-ipv6

Anonymized DNS relay in London. https://www.dnscrypt.uk

sdns://gRpbMmEwMzpiMGMwOjE6ZTA6OjQ4NzoxMDAxXQ


## anon-dnswarden-swiss

Relay hosted in swizterland.
For more information look at https://github.com/bhanupratapys/dnswarden or https://dnswarden.com

sdns://gRQxODguMjQ0LjExNy4xMTQ6MTQ0Mw


## anon-fluffycat-fr-01

Anonymized DNS relay hosted in Marseille, FR on Oracle Cloud.

sdns://gRQxMjkuMTUxLjIyNC4xODI6NTM1Mw


## anon-inconnu

Anonymized DNS relay hosted in Seattle, WA (USA), maintained by Eric
Lagergren (@ericlagergren). Running the official Docker image on Vultr.

sdns://gQ4xMDQuMjM4LjE1My40Ng


## anon-kama

Anonymized DNS relay hosted in France and maintained by Frank Denis (@jedisct1).

sdns://gQ4xMzcuNzQuMjIzLjIzNA


## anon-saldns01-conoha-ipv4

Hosted on ConoHa VPS Tokyo region. No log. From experimental &mu;ODNS project https://junkurihara.github.io/dns/.

sdns://gRQxNjMuNDQuMTI0LjIwNDo1MDQ0Mw


## anon-saldns02-conoha-ipv4

Hosted on ConoHa VPS Tokyo region. No log. From experimental &mu;ODNS project https://junkurihara.github.io/dns/.

sdns://gRUxNjAuMjUxLjIxNC4xNzI6NTA0NDM


## anon-saldns03-conoha-ipv4

Hosted on ConoHa VPS Tokyo region. No log. From experimental &mu;ODNS project https://junkurihara.github.io/dns/.

sdns://gRQxNjAuMjUxLjE2OC4yNTo1MDQ0Mw


## anon-scaleway

Anonymized DNS relay hosted in France and maintained by Frank Denis (@jedisct1).

sdns://gRIyMTIuNDcuMjI4LjEzNjo0NDM


## anon-scaleway-ams

Anonymized DNS relay hosted in Amsterdam and maintained by Frank Denis (@jedisct1).

sdns://gRE1MS4xNS4xMjIuMjUwOjQ0Mw


## anon-scaleway-ams-ipv6

Anonymized DNS relay hosted in Amsterdam and maintained by Frank Denis (@jedisct1).
IPv6 only.

sdns://gSpbMjAwMTpiYzg6MTY0MDoxY2UyOmRjMDA6ZmY6ZmUyODo1YjE3XTo0NDM


## anon-scaleway-ipv6

Anonymized DNS relay hosted in France and maintained by Frank Denis (@jedisct1).
IPv6 only.

sdns://gSlbMjAwMTpiYzg6NzEwOjU4MTg6ZGMwMDpmZjpmZTViOjNmNjNdOjQ0Mw


## anon-scaleway2

Anonymized DNS relay hosted in France and maintained by Frank Denis (@jedisct1).

sdns://gRMxNjMuMTcyLjE4MC4xMjU6NDQz


## anon-serbica

Anonymized DNS relay hosted in Netherlands by https://litepay.ch

sdns://gRMxODUuNjYuMTQzLjE3ODo1MzUz


## anon-tiarap

Anonymized DNS relay hosted in Singapore

sdns://gRMxNzQuMTM4LjI5LjE3NToxNDQz


## anon-v.dnscrypt.uk-ipv4

Anonymized DNS relay hosted in UK on Vultr

sdns://gQ8xMDQuMjM4LjE4Ni4xOTI


## anon-v.dnscrypt.uk-ipv6

Anonymized DNS relay hosted in UK on Vultr

sdns://gShbMjAwMToxOWYwOjc0MDI6MTU3NDo1NDAwOjJmZjpmZTY2OjJjZmZd


## dnscry.pt-anon-allentown-ipv4

DNSCry.pt Allentown - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMy4xMzcuMjUzLjI0


## dnscry.pt-anon-allentown-ipv6

DNSCry.pt Allentown - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRxbMjYwMjpmYzI0OjE5Ojc0YjA6NTI4NTo6MTJd


## dnscry.pt-anon-amsterdam-ipv4

DNSCry.pt Amsterdam - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xOTguMTQwLjE0MS40Ng


## dnscry.pt-anon-amsterdam-ipv6

DNSCry.pt Amsterdam - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMmEwMzo5NGUzOjIyMmI6OjEwMzJd


## dnscry.pt-anon-amsterdam02-ipv4

DNSCry.pt Amsterdam 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS44Ni4xNjIuMTEw


## dnscry.pt-anon-amsterdam02-ipv6

DNSCry.pt Amsterdam 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMmEwNzplZmMwOjEwMDE6YTVjZTo6YjRiNF0


## dnscry.pt-anon-ashburn-ipv6

DNSCry.pt Ashburn - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjAwMTo0NzA6ODoxNjk6OjEwMF0


## dnscry.pt-anon-athens-ipv4

DNSCry.pt Athens - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xODUuMjM0LjUyLjg3


## dnscry.pt-anon-athens-ipv6

DNSCry.pt Athens - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwOTpjZDQzOmY6NDJhMTo6NV0


## dnscry.pt-anon-atlanta-ipv4

DNSCry.pt Atlanta - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNzAuMjQ5LjIzNy4xNTQ


## dnscry.pt-anon-atlanta-ipv6

DNSCry.pt Atlanta - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMjYwMDo0YzAwOjgwOjg6OmFd


## dnscry.pt-anon-auckland-ipv4

DNSCry.pt Auckland - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xODUuOTkuMTMzLjExMg


## dnscry.pt-anon-auckland-ipv6

DNSCry.pt Auckland - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRxbMmEwNjoxMjgwOmJlZTE6Mjo6ZWUxMjoyMDhd


## dnscry.pt-anon-bengaluru-ipv4

DNSCry.pt Bengaluru - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNjAuMTkxLjE4Mi4yMTY


## dnscry.pt-anon-bratislava-ipv4

DNSCry.pt Bratislava - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ45NS4xMzEuMjAyLjEwNQ


## dnscry.pt-anon-bratislava-ipv6

DNSCry.pt Bratislava - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR1bMmEwNTo1NTAyOjo1OTA2Ojk3Zjg6MmQwZToxXQ


## dnscry.pt-anon-brisbane-ipv4

DNSCry.pt Brisbane - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ40My4yMjQuMTgwLjEzNw


## dnscry.pt-anon-brisbane-ipv6

DNSCry.pt Brisbane - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSJbMjQwNDo5NDAwOjE6MDoyMTY6M2VmZjpmZWY2OjcxOTRd


## dnscry.pt-anon-brussels-ipv4

DNSCry.pt Brussels - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xOTIuMTIxLjE3MC4xNTE


## dnscry.pt-anon-brussels-ipv6

DNSCry.pt Brussels - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwMzpmODA6MzI6NTJkOTo6MV0


## dnscry.pt-anon-bucharest-ipv4

DNSCry.pt Bucharest - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xODUuOTMuMjIxLjE2Nw


## dnscry.pt-anon-bucharest-ipv6

DNSCry.pt Bucharest - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMmEwZDo5ZWMyOjA6ZjAzZDo6YzQ5ZV0


## dnscry.pt-anon-calgary-ipv4

DNSCry.pt Calgary - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMy4xMzMuNjQuMTIx


## dnscry.pt-anon-calgary-ipv6

DNSCry.pt Calgary - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMjYwMjpmZWQyOmZlMDoyODM6OjFd


## dnscry.pt-anon-chicago-ipv4

DNSCry.pt Chicago - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS40MS4yMDQuMjA0


## dnscry.pt-anon-chicago-ipv6

DNSCry.pt Chicago - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR9bMjYwMjpmZWE3OmUwYzplOmJmZjo2OjcwOjE5NGNd


## dnscry.pt-anon-chisinau-ipv4

DNSCry.pt Chișinău - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xNzYuMTIzLjEwLjEwNQ


## dnscry.pt-anon-chisinau-ipv6

DNSCry.pt Chișinău - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR1bMjAwMTo2Nzg6NmQ0OjUwODA6OjNkZWE6MTA5XQ


## dnscry.pt-anon-copenhagen-ipv4

DNSCry.pt Copenhagen - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQs4NS4xMjAuODQuNQ


## dnscry.pt-anon-copenhagen-ipv6

DNSCry.pt Copenhagen - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR5bMmEwZToxZDgwOjMxOjhhNTY6MDpiMGU6NWU6MF0


## dnscry.pt-anon-coventry-ipv4

DNSCry.pt Coventry - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS4xNTUuMzcuMTY1


## dnscry.pt-anon-coventry-ipv6

DNSCry.pt Coventry - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMmEwZDpkOGMwOjA6ZjA0Mzo6NjkyN10


## dnscry.pt-anon-dallas-ipv6

DNSCry.pt Dallas - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMjYwMjpmYjk0OjE6Mzk6OmFd


## dnscry.pt-anon-denver-ipv4

DNSCry.pt Denver - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8yMTYuMTIwLjIwMS4xMDU


## dnscry.pt-anon-denver-ipv6

DNSCry.pt Denver - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjYwNzphNjgwOjY6ZjAxNjo6M2EyNV0


## dnscry.pt-anon-dublin-ipv4

DNSCry.pt Dublin - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTQuMjYuMjEzLjE1


## dnscry.pt-anon-dublin-ipv6

DNSCry.pt Dublin - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwOTpjZDQ2OmY6NDI5ZTo6NV0


## dnscry.pt-anon-durham-ipv4

DNSCry.pt Durham - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwzOC40NS42NC4xMTc


## dnscry.pt-anon-durham-ipv6

DNSCry.pt Durham - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR1bMjAwMTo1NTA6NWEwMDo1ZWI6OmRiNTpmMDAxXQ


## dnscry.pt-anon-dusseldorf-ipv4

DNSCry.pt Düsseldorf - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xODUuMjQ0LjI3LjEzNg


## dnscry.pt-anon-dusseldorf-ipv6

DNSCry.pt Düsseldorf - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMmEwZjo1NzA3OmFhODE6NWUzYzo6MV0


## dnscry.pt-anon-dusseldorf02-ipv4

DNSCry.pt Düsseldorf 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS4xMzMuNzUuMTIy


## dnscry.pt-anon-flint-ipv4

DNSCry.pt Flint - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNDcuMTg5LjE0MC4xMzY


## dnscry.pt-anon-flint-ipv6

DNSCry.pt Flint - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMjYwNjo2NjgwOjI5OjE6OjU4NTk6YTM3Yl0


## dnscry.pt-anon-frankfurt-ipv4

DNSCry.pt Frankfurt - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTQuNTAuMTkuMTUw


## dnscry.pt-anon-frankfurt-ipv6

DNSCry.pt Frankfurt - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSNbMmEwZjo1NzA3OmFiODA6MzM0ZToyOjI6MmNkMjphOGJjXQ


## dnscry.pt-anon-frankfurt02-ipv4

DNSCry.pt Frankfurt 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS4xNDcuNTEuMTIz


## dnscry.pt-anon-frankfurt02-ipv6

DNSCry.pt Frankfurt 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmEwNzpkODg0OjEwMDo6MzQ0XQ


## dnscry.pt-anon-fremont-ipv4

DNSCry.pt Fremont - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwyMy4xMzQuODguNzE


## dnscry.pt-anon-fremont-ipv6

DNSCry.pt Fremont - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwMjpmYmExOjEwMDo6NzE6MV0


## dnscry.pt-anon-fujairah-ipv4

DNSCry.pt Fujairah - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ04OS4zNi4xNjIuMTg3


## dnscry.pt-anon-fujairah-ipv6

DNSCry.pt Fujairah - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gShbMmEwNjpmOTAyOjQwMDE6MTAwOjkwMDA6OTAwMDozOWE0OjVmZWJd


## dnscry.pt-anon-geneva-ipv4

DNSCry.pt Geneva - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw0NS45MC41OS4xOTM


## dnscry.pt-anon-geneva-ipv6

DNSCry.pt Geneva - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRBbMmEwNTo5NDA2OjphZTFd


## dnscry.pt-anon-grandrapids-ipv4

DNSCry.pt Grand Rapids - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xODUuMTY1LjQ0LjE2NA


## dnscry.pt-anon-grandrapids-ipv6

DNSCry.pt Grand Rapids - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMjYwMjpmOTY0OjE6MjQ6OmFd


## dnscry.pt-anon-hafnarfjordur-ipv4

DNSCry.pt Hafnarfjordur - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xNTEuMjM2LjI0LjE5MA


## dnscry.pt-anon-hafnarfjordur-ipv6

DNSCry.pt Hafnarfjordur - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMmEwMzpmODA6MzU0OjM4Yjc6OjFd


## dnscry.pt-anon-halifax-ipv4

DNSCry.pt Halifax - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwyMy4xOTEuODAuNzI


## dnscry.pt-anon-halifax-ipv6

DNSCry.pt Halifax - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwMjpmYzFjOmZhMDoxMTo6MV0


## dnscry.pt-anon-hanoi-ipv4

DNSCry.pt Hanoi - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xMDMuMTk5LjE2Ljkz


## dnscry.pt-anon-hanoi-ipv6

DNSCry.pt Hanoi - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjQwNDpmYmMwOjA6MTFjODo6YTMyNF0


## dnscry.pt-anon-helsinki-ipv4

DNSCry.pt Helsinki - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4zNy4yMjguMTI5LjE2MA


## dnscry.pt-anon-helsinki-ipv6

DNSCry.pt Helsinki - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwNjoxNzAwOjE6M2E6OmNiYV0


## dnscry.pt-anon-hochiminhcity-ipv4

DNSCry.pt Ho-Chi-Minh City - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xNTcuMjAuODMuMTM1


## dnscry.pt-anon-hochiminhcity-ipv6

DNSCry.pt Ho-Chi-Minh City - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjQwMDo2ZWEwOjA6MTFhZTo6YWRjNF0


## dnscry.pt-anon-hongkong-ipv4

DNSCry.pt Hong Kong - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQs5Ni45LjIyOC4yNw


## dnscry.pt-anon-hongkong-ipv6

DNSCry.pt Hong Kong - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRlbMjAwMTpkZjE6ODAxOmEwMjI6OmM0OmFd


## dnscry.pt-anon-hongkong02-ipv4

DNSCry.pt Hong Kong 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw5MS4xMjQuMzAuMzE


## dnscry.pt-anon-hongkong02-ipv6

DNSCry.pt Hong Kong 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwMjpmYTY3OjEwMToyMDo6YV0


## dnscry.pt-anon-houston-ipv4

DNSCry.pt Houston - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4yMDkuMTM1LjE3MC41MQ


## dnscry.pt-anon-houston-ipv6

DNSCry.pt Houston - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMjYwMjpmOWYzOjA6Mjo6MTkzXQ


## dnscry.pt-anon-hudiksvall-ipv4

DNSCry.pt Hudiksvall - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ45NS4xNDMuMTk2LjE5MA


## dnscry.pt-anon-hudiksvall-ipv6

DNSCry.pt Hudiksvall - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRxbMmEwMzpkNzgwOjA6MTk2OjozZTg0OjU2YWZd


## dnscry.pt-anon-islamabad-ipv6

DNSCry.pt Islamabad - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRdbMjAwMTpkZjI6ZDQwOjE3OjpiYWJhXQ


## dnscry.pt-anon-jacksonville-ipv4

DNSCry.pt Jacksonville - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xMDQuMjI1LjEyOS4xMDY


## dnscry.pt-anon-jacksonville-ipv6

DNSCry.pt Jacksonville - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjYwNzphNjgwOjQ6ZjAwMzo6ZWMzMl0


## dnscry.pt-anon-johannesburg-ipv4

DNSCry.pt Johannesburg - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNjkuMjM5LjEyOC4xMjQ


## dnscry.pt-anon-johannesburg-ipv6

DNSCry.pt Johannesburg - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmMwZjpmNTMwOjpkMDA6MTg4XQ


## dnscry.pt-anon-johor-ipv4

DNSCry.pt Johor - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ00NS4yNDkuOTEuMTUw


## dnscry.pt-anon-johor-ipv6

DNSCry.pt Johor - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjAwMTpkZjQ6MTg0MDo5Zjo6YV0


## dnscry.pt-anon-kansascity-ipv4

DNSCry.pt Kansas City - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMy4xNTAuNDAuMTIx


## dnscry.pt-anon-kansascity-ipv6

DNSCry.pt Kansas City - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRlbMjYwMjoyYjc6ZDAxOmMyOTU6OmI6MThd


## dnscry.pt-anon-kharkiv-ipv4

DNSCry.pt Kharkiv - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xOTMuMjM4LjE1My4xNw


## dnscry.pt-anon-kharkiv-ipv6

DNSCry.pt Kharkiv - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmEwMjoyN2E4OmZlZWQ6OjgxXQ


## dnscry.pt-anon-kyiv-ipv4

DNSCry.pt Kyiv - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMTcuMTIuMjIxLjYx


## dnscry.pt-anon-kyiv-ipv6

DNSCry.pt Kyiv - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRBbMmEwMjoyN2FkOjoyMDFd


## dnscry.pt-anon-lagos-ipv4

DNSCry.pt Lagos - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xNzYuOTcuMTkyLjEy


## dnscry.pt-anon-lagos-ipv6

DNSCry.pt Lagos - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR9bMmEwNjpmOTAxOjQwMDE6MTAwOjoyZDZjOjczNmFd


## dnscry.pt-anon-lasvegas-ipv4

DNSCry.pt Las Vegas - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMDkuMTQxLjQ1LjI3


## dnscry.pt-anon-lasvegas-ipv6

DNSCry.pt Las Vegas - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSVbMjYwNTo2NDAwOjIwOjIyNTg6N2FjYjo5MWZmOjIwOTg6YTld


## dnscry.pt-anon-libertylake-ipv4

DNSCry.pt Liberty Lake - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwyMy4xODQuNDguMTk


## dnscry.pt-anon-libertylake-ipv6

DNSCry.pt Liberty Lake - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjYwMjpmYzI0OjE4OjMzZjI6OmFiMV0


## dnscry.pt-anon-lima02-ipv4

DNSCry.pt Lima 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw4Ny4xMjEuOTkuMjM


## dnscry.pt-anon-lima02-ipv6

DNSCry.pt Lima 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMmEwMzo5MGMwOjU1NTo6NzJd


## dnscry.pt-anon-lisbon-ipv4

DNSCry.pt Lisbon - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xODUuMjE5LjEzMC4y


## dnscry.pt-anon-lisbon-ipv6

DNSCry.pt Lisbon - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRpbMmEwZTpiYzAwOjoxODU6MjE5OjEzMDoyXQ


## dnscry.pt-anon-london-ipv4

DNSCry.pt London - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw0NS42Ny44NC4xMzI


## dnscry.pt-anon-london-ipv6

DNSCry.pt London - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmEwNTo0MTQwOjcwMDplOjphXQ


## dnscry.pt-anon-losangeles-ipv4

DNSCry.pt Los Angeles - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMTYuNzMuMTU2LjUy


## dnscry.pt-anon-losangeles-ipv6

DNSCry.pt Los Angeles - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwMjpmYWZkOjkwMjoyMDo6YV0


## dnscry.pt-anon-losangeles02-ipv4

DNSCry.pt Los Angeles 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMDQuMjAwLjY3LjE5NA


## dnscry.pt-anon-losangeles02-ipv6

DNSCry.pt Los Angeles 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRdbMjYwMjpmZjc1Ojc6Yjc5OjpiNGI0XQ


## dnscry.pt-anon-luxembourg-ipv4

DNSCry.pt Luxembourg - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw0NS44MC4yMDkuNTU


## dnscry.pt-anon-luxembourg-ipv6

DNSCry.pt Luxembourg - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMmEwMzo5MGMwOjg1OjoxMDJd


## dnscry.pt-anon-madrid-ipv4

DNSCry.pt Madrid - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ01LjEzNC4xMTguMTk4


## dnscry.pt-anon-madrid-ipv6

DNSCry.pt Madrid - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMmEwMzpjN2MwOjUyOjI2NDE6MTgwOjoxM10


## dnscry.pt-anon-manchester-ipv4

DNSCry.pt Manchester - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ04MS4xODEuMTA4LjQw


## dnscry.pt-anon-manchester-ipv6

DNSCry.pt Manchester - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR1bMmEwZToxZDgwOjU6ODJlOTo1Njc4OjkxMDo6XQ


## dnscry.pt-anon-miami-ipv4

DNSCry.pt Miami - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMjguMjU0LjIwNy41MA


## dnscry.pt-anon-miami-ipv6

DNSCry.pt Miami - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMjYwMjpmYWZkOmZiMjoxOjphXQ


## dnscry.pt-anon-montreal-ipv4

DNSCry.pt Montreal - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNDcuMTg5LjEzNi4xODM


## dnscry.pt-anon-montreal-ipv6

DNSCry.pt Montreal - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRpbMjYwNjo2NjgwOjQ1OjE6OmY3OGM6OWIwXQ


## dnscry.pt-anon-moscow-ipv4

DNSCry.pt Moscow - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ45My4xODMuMTA1LjEwOQ


## dnscry.pt-anon-moscow-ipv6

DNSCry.pt Moscow - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmEwYzpjNTgwOjA6MTo6MjoxXQ


## dnscry.pt-anon-mumbai-ipv4

DNSCry.pt Mumbai - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMDMuMTExLjExNC4yNQ


## dnscry.pt-anon-mumbai-ipv6

DNSCry.pt Mumbai - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR9bMmEwNjpmOTAyOjgwMDE6MTAwOjoxNzU3OmU2MTdd


## dnscry.pt-anon-munich-ipv4

DNSCry.pt Munich - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTQuMzkuMjA1LjEw


## dnscry.pt-anon-munich-ipv6

DNSCry.pt Munich - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRpbMmEwYzo4ZmMwOjE3NDk6NjY6MTg6OjE2XQ


## dnscry.pt-anon-naaldwijk-ipv4

DNSCry.pt Naaldwijk - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMy4xMzcuMjQ5LjI2


## dnscry.pt-anon-naaldwijk-ipv6

DNSCry.pt Naaldwijk - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjYwMjpmYzI0OjEyOjk4NzM6OmFiMV0


## dnscry.pt-anon-nuremberg-ipv4

DNSCry.pt Nuremberg - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMDIuNjEuMjM2LjY3


## dnscry.pt-anon-nuremberg-ipv6

DNSCry.pt Nuremberg - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSVbMmEwMzo0MDAwOjVjOjUxOjI0Yjk6NTFmZjpmZTgwOmYzYTdd


## dnscry.pt-anon-oradea-ipv4

DNSCry.pt Oradea - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTMuMzIuODcuMTI3


## dnscry.pt-anon-oradea-ipv6

DNSCry.pt Oradea - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR5bMmEwZDo4MTQzOjA6MTI0OjI5MTU6YWY6MDoxOF0


## dnscry.pt-anon-ottoville-ipv4

DNSCry.pt Ottoville - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xMDQuMjM0LjIzMS4yMzk


## dnscry.pt-anon-ottoville-ipv6

DNSCry.pt Ottoville - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMjYwMjpmOTUzOjY6MjU6OmFd


## dnscry.pt-anon-paris-ipv4

DNSCry.pt Paris - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQs4OS4xMTcuMi4xNw


## dnscry.pt-anon-paris-ipv6

DNSCry.pt Paris - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR5bMjQwMjpkMGMwOjIyOjZjZDA6NDo0OjQ6NWI4MV0


## dnscry.pt-anon-philadelphia-ipv4

DNSCry.pt Philadelphia - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xNTQuMTYuMTU5LjIy


## dnscry.pt-anon-philadelphia-ipv6

DNSCry.pt Philadelphia - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwNDpiZjAwOjIxMDoxMjo6Ml0


## dnscry.pt-anon-phoenix-ipv4

DNSCry.pt Phoenix - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xNzMuMjQ5LjIwMy41Mg


## dnscry.pt-anon-phoenix-ipv6

DNSCry.pt Phoenix - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMjYwNzoxZTQwOjE6MTBhNDo6MTk6Y2E4NF0


## dnscry.pt-anon-portedwards-ipv4

DNSCry.pt Port Edwards - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNzYuMTExLjIxOS4xMjY


## dnscry.pt-anon-portedwards-ipv6

DNSCry.pt Port Edwards - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjAwMTo0NzA6MWYxMToyYmI6OmIyM10


## dnscry.pt-anon-portland-ipv4

DNSCry.pt Portland - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xMDMuMTI0LjEwNi4yMzM


## dnscry.pt-anon-portland-ipv6

DNSCry.pt Portland - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSFbMjQwMjpkMGMwOjE2OmExZTY6MDpiODkzOmJmNzpkZF0


## dnscry.pt-anon-prague-ipv4

DNSCry.pt Prague - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xOTUuMTIzLjI0NS4xOQ


## dnscry.pt-anon-prague-ipv6

DNSCry.pt Prague - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRBbMmEwNTo5NDAzOjo5OTld


## dnscry.pt-anon-redditch-ipv4

DNSCry.pt Redditch - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw0NS42Ny44NS4yMTk


## dnscry.pt-anon-redditch-ipv6

DNSCry.pt Redditch - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMmEwNTo0MTQwOjE5OjUzOjphXQ


## dnscry.pt-anon-riga-ipv4

DNSCry.pt Riga - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xOTUuMTIzLjIxMi4yMDA


## dnscry.pt-anon-riga-ipv6

DNSCry.pt Riga - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRFbMmEwMjoyN2FjOjoxMjQ5XQ


## dnscry.pt-anon-saltlakecity-ipv4

DNSCry.pt Salt Lake City - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMDMuMTE0LjE2Mi42NQ


## dnscry.pt-anon-saltlakecity-ipv6

DNSCry.pt Salt Lake City - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gSFbMjQwMjpkMGMwOjE4OmM4ZmY6MDpiODkzOmJmNzpkZF0


## dnscry.pt-anon-sandefjord-ipv4

DNSCry.pt Sandefjord - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTQuMzIuMTA3LjQ4


## dnscry.pt-anon-sandefjord-ipv6

DNSCry.pt Sandefjord - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwMzo5NGUwOjI3MWY6OjViMV0


## dnscry.pt-anon-santaclara-ipv4

DNSCry.pt Santa Clara - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNzYuMTExLjIyMy4xNjc


## dnscry.pt-anon-santaclara-ipv6

DNSCry.pt Santa Clara - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMjYwNjo2NjgwOjM1OjE6OjUwNmQ6OGNlMl0


## dnscry.pt-anon-saopaulo-ipv4

DNSCry.pt Sao Paulo - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMDguMTgxLjY5LjE1Mw


## dnscry.pt-anon-saopaulo-ipv6

DNSCry.pt Sao Paulo - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR5bMjYwNDo2NjAwOmZkMDA6OTA6OjFiOGI6M2EzY10


## dnscry.pt-anon-seattle-ipv4

DNSCry.pt Seattle - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8yMDkuMTgyLjIyNS4xMDM


## dnscry.pt-anon-seattle-ipv6

DNSCry.pt Seattle - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjYwNzphNjgwOjk6ZjAwNTo6ODZlN10


## dnscry.pt-anon-seoul-ipv4

DNSCry.pt Seoul - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ05Mi4zOC4xMzUuMTI4


## dnscry.pt-anon-seoul-ipv6

DNSCry.pt Seoul - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMmEwMzo5MGMwOjEyNTo6ODhd


## dnscry.pt-anon-singapore-ipv4

DNSCry.pt Singapore - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMy4yNy4xMDEuMTkx


## dnscry.pt-anon-singapore-ipv6

DNSCry.pt Singapore - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwNjpmYzQwOjQwMDM6Zjo6YV0


## dnscry.pt-anon-singapore02-ipv4

DNSCry.pt Singapore 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xMDMuMTc5LjQ0Ljcz


## dnscry.pt-anon-singapore02-ipv6

DNSCry.pt Singapore 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMjQwMTo0NTIwOjExMjI6OmFd


## dnscry.pt-anon-sofia-ipv4

DNSCry.pt Sofia - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQs3OS4xMjQuNzcuMw


## dnscry.pt-anon-sofia-ipv6

DNSCry.pt Sofia - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMmEwMTo4NzQwOjE6NDA6OjhhMjVd


## dnscry.pt-anon-spokane-ipv4

DNSCry.pt Spokane - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xMDQuMzYuODYuMTgx


## dnscry.pt-anon-spokane-ipv6

DNSCry.pt Spokane - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRRbMjYwNjphOGMwOjM6MjAyOjphXQ


## dnscry.pt-anon-stockholm-ipv4

DNSCry.pt Stockholm - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xODUuMTk1LjIzNi42Mg


## dnscry.pt-anon-stockholm-ipv6

DNSCry.pt Stockholm - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMmEwOTpiMjgwOmZlMDE6MzU6OmFd


## dnscry.pt-anon-sydney-ipv4

DNSCry.pt Sydney - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw4NC4zMy4xNS4xMDA


## dnscry.pt-anon-sydney-ipv6

DNSCry.pt Sydney - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gR9bMmEwYzo4ZmMxOjgwMDQ6NTUzOjoxNDVhOmJiZjld


## dnscry.pt-anon-sydney02-ipv4

DNSCry.pt Sydney 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xOTUuMTE0LjE0Ljc0


## dnscry.pt-anon-sydney02-ipv6

DNSCry.pt Sydney 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRhbMjQwMjo3MzQwOjUwMDA6NjIwMDo6YV0


## dnscry.pt-anon-taipeh-ipv4

DNSCry.pt Taipeh - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ4xMDMuMTMxLjE4OS4xMQ


## dnscry.pt-anon-taipeh-ipv6

DNSCry.pt Taipeh - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRpbMjQwMzpjZmMwOjEwMDQ6MzY5Ojo1YjIxXQ


## dnscry.pt-anon-tallinn-ipv4

DNSCry.pt Tallinn - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xODUuMTk0LjUzLjIy


## dnscry.pt-anon-tallinn-ipv6

DNSCry.pt Tallinn - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRJbMmEwNDo2ZjAwOjQ6OjE3YV0


## dnscry.pt-anon-tampa-ipv4

DNSCry.pt Tampa - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ8xNjUuMTQwLjExNy4yNDg


## dnscry.pt-anon-tampa-ipv6

DNSCry.pt Tampa - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRlbMjYwMjpmY2MwOjIyMjI6OWQyZTo6NTNd


## dnscry.pt-anon-taos-ipv4

DNSCry.pt Taos - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ42My4xMzMuMjIzLjEzOA


## dnscry.pt-anon-taos-ipv6

DNSCry.pt Taos - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRtbMjYwNjo2NjgwOjUzOjE6Ojg0NmE6YmQ3OV0


## dnscry.pt-anon-tbilisi-ipv6

DNSCry.pt Tbilisi - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRpbMmExMjplMzQwOjMwMDo6YmMzNDo5M2U0XQ


## dnscry.pt-anon-tokyo-ipv4

DNSCry.pt Tokyo - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQw0NS42Ny44Ni4xMjM


## dnscry.pt-anon-tokyo-ipv6

DNSCry.pt Tokyo - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwNjpmYzQwOjQwMDI6ZDo6YV0


## dnscry.pt-anon-tokyo02-ipv4

DNSCry.pt Tokyo 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwxMDMuMTc5LjQ1LjY


## dnscry.pt-anon-tokyo02-ipv6

DNSCry.pt Tokyo 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRNbMmEwYTo2MDQwOjk3M2Q6OmFd


## dnscry.pt-anon-toronto-ipv4

DNSCry.pt Toronto - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwyMy4xMzQuODkuMjM


## dnscry.pt-anon-toronto-ipv6

DNSCry.pt Toronto - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMjYwMjpmYmExOmQwMDo6MjM6MV0


## dnscry.pt-anon-tuusula-ipv4

DNSCry.pt Tuusula - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ02NS4yMS4yNTIuMjAx


## dnscry.pt-anon-tuusula-ipv6

DNSCry.pt Tuusula - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRdbMmEwMTo0Zjk6YzAxMTpiODRlOjoxXQ


## dnscry.pt-anon-valdivia-ipv4

DNSCry.pt Valdivia - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0yMTYuNzMuMTU5LjI2


## dnscry.pt-anon-valdivia-ipv6

DNSCry.pt Valdivia - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRVbMmEwNjphMDA2OmQxZDE6OjExNl0


## dnscry.pt-anon-vancouver-ipv4

DNSCry.pt Vancouver - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQwyMy4xNTQuODEuOTI


## dnscry.pt-anon-vilnius-ipv4

DNSCry.pt Vilnius - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ0xNjIuMjU0Ljg2LjEz


## dnscry.pt-anon-vilnius-ipv6

DNSCry.pt Vilnius - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRdbMmExMzo5NDAxOjA6MTo6M2Q1ODoxXQ


## dnscry.pt-anon-warsaw02-ipv4

DNSCry.pt Warsaw 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ44OC4yMTguMjA2LjEzNw


## dnscry.pt-anon-warsaw02-ipv6

DNSCry.pt Warsaw 02 - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRZbMmEwOTpiMjgwOmZlMDA6MjQ6OmFd


## dnscry.pt-anon-yerevan-ipv4

DNSCry.pt Yerevan - DNSCrypt, no filter, no logs, DNSSEC support (IPv4 server)

https://www.dnscry.pt

sdns://gQ04NS45MC4yMDcuMTk5


## dnscry.pt-anon-yerevan-ipv6

DNSCry.pt Yerevan - DNSCrypt, no filter, no logs, DNSSEC support (IPv6 server)

https://www.dnscry.pt

sdns://gRlbMmEwMzo5MGMwOjVmMToyOTAzOjo1Mzld

